/**HEADER********************************************************************
*
* Copyright (c) 2012 Freescale Semiconductor;
* All Rights Reserved
*
***************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
* THE POSSIBILITY OF SUCH DAMAGE.
*
**************************************************************************
*
* $FileName: cache_a5.c$
* $Version : 3.8.4.0$
* $Date    : Aug-29-2012$
*
* Comments:
*
*   This file contains functions for use with the cortex  a5 caches.
*   Funcionality of L1 cache is accessible on by special instructions mcr - for write and mrc for read.
*
*
*END************************************************************************/
#include "iar_comp.h"
#include <stdint.h>

void _a5_dcache_invalidate()
{
    uint32_t csid, wayset;  /* Cache Size ID , wayset parameter */
    int32_t num_sets, num_ways; /* number of sets  */

    MRC(15, 1, csid, 0, 0, 0);    /* Read Cache Size ID */
    /* Fill number of sets  and number of ways from csid register  This walues are decremented by 1*/
    num_ways = (csid >> 0x03) & 0x3FFu; //((csid& csid_ASSOCIATIVITY_MASK) >> csid_ASSOCIATIVITY_SHIFT`)
    /* Invalidation all lines (all Sets in all ways) */
    while (num_ways >= 0)
    {
        num_sets = (csid >> 0x13) & 0x7FFFu; //((csid & csid_NUMSETS_MASK)      >> csid_NUMSETS_SHIFT       )
        while (num_sets >= 0 )
        {
            wayset = (num_sets << 5u) | (num_ways << 30u); //(num_sets << SETWAY_SET_SHIFT) | (num_sets << 3SETWAY_WAY_SHIFT)
            /* invalidate line if we know set and way */
            MCR(15, 0, wayset, 7, 6, 2);
            num_sets--;
        }
        num_ways--;
    }
    /* All Cache, Branch predictor and TLB maintenance operations before followed instruction complete*/
    DSB();
}


/*FUNCTION*-------------------------------------------------------------------
*
* Function Name    : _a5_dcache_flush
* Returned Value   : none
* Comments         :
*   This function FLUSH (CLEAN) all lines of cachce (all sets in all ways)
*   Size of line for A5 L1 cache is 32B.
*
*END*----------------------------------------------------------------------*/
void _a5_dcache_flush()
{
    uint32_t csid, wayset;  /* Cache Size ID */
    int32_t num_sets, num_ways; /* number of sets  */

    MRC(15, 1, csid, 0, 0, 0);    /* Read Cache Size ID */
    /* Fill number of sets  and number of ways from csid register  This walues are decremented by 1*/
    num_ways = (csid >> 0x03) & 0x3FFu; //((csid& csid_ASSOCIATIVITY_MASK) >> csid_ASSOCIATIVITY_SHIFT`)
    while (num_ways >= 0)
    {
        num_sets = (csid >> 0x13) & 0x7FFFu; //((csid & csid_NUMSETS_MASK)      >> csid_NUMSETS_SHIFT       )
        while (num_sets >= 0 )
        {
            wayset = (num_sets << 5u) | (num_ways << 30u); //(num_sets << SETWAY_SET_SHIFT) | (num_ways << 3SETWAY_WAY_SHIFT)
            /* FLUSH (clean) line if we know set and way */
            MCR(15, 0, wayset, 7, 10, 2);
            num_sets--;
        }
        num_ways--;
    }
    /* All Cache, Branch predictor and TLB maintenance operations before followed instruction complete*/
    DSB();
}

void _a5_icache_invalidate()
{
    uint32_t SBZ;
    SBZ = 0x0u;
    MCR(15, 0, SBZ, 7, 5, 0);
    /* synchronize context on this processor */
    ISB();
}

/*FUNCTION*-------------------------------------------------------------------
*
* Function Name    : _a5_icache_invalidate_line
* Comments         :
*   This function is called to invalidate a line.
*
*END*------------------------------------------------------------------------*/
void _a5_icache_invalidate_line(uint32_t* addr)
{
    uint32_t va;
    va = (uint32_t) addr & 0xfffffff0; //addr & va_VIRTUAL_ADDRESS_MASK
    /* Invalidate instruction cache by va to PoU (Point of unification). */
    MCR(15, 0, va, 7, 5, 1);
    /* synchronize context on this processor */
    ISB();
}


